#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef Gothic14_H
#define Gothic14_H


static uint8_t Gothic14[] PROGMEM = {
    0x21, 0xDE, // size
    0x0A, // width
    0x0E, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x02, 0x03, 0x07, 0x07, 0x0A, 0x09, 0x01, 0x03, 0x02, 
    0x03, 0x07, 0x03, 0x04, 0x02, 0x05, 0x07, 0x02, 0x07, 0x07, 
    0x07, 0x07, 0x07, 0x08, 0x07, 0x07, 0x03, 0x04, 0x06, 0x06, 
    0x06, 0x06, 0x0A, 0x08, 0x07, 0x0A, 0x09, 0x07, 0x06, 0x0B, 
    0x09, 0x02, 0x06, 0x07, 0x05, 0x0B, 0x09, 0x0B, 0x07, 0x0B, 
    0x08, 0x06, 0x07, 0x08, 0x09, 0x0D, 0x09, 0x08, 0x07, 0x03, 
    0x07, 0x03, 0x07, 0x07, 0x02, 0x09, 0x09, 0x08, 0x09, 0x08, 
    0x04, 0x08, 0x07, 0x02, 0x02, 0x06, 0x02, 0x0B, 0x07, 0x08, 
    0x09, 0x09, 0x04, 0x04, 0x05, 0x07, 0x07, 0x0B, 0x07, 0x06, 
    0x05, 0x05, 0x01, 0x04, 0x06, 0x07, 
    
    // font data
    0xE0, 0x1E, 0x18, 0x18, // 33
    0x0E, 0x00, 0x0E, 0x00, 0x00, 0x00, // 34
    0x90, 0x90, 0xF8, 0x96, 0xF8, 0x96, 0x90, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x00, 0x00, // 35
    0x00, 0x1C, 0x36, 0xFA, 0x67, 0x42, 0x84, 0x0C, 0x18, 0x78, 0x14, 0x10, 0x08, 0x0C, // 36
    0x1C, 0x26, 0x22, 0xB2, 0x5E, 0xA2, 0xD2, 0x4A, 0x46, 0x82, 0x10, 0x08, 0x04, 0x00, 0x00, 0x0C, 0x10, 0x10, 0x18, 0x0C, // 37
    0x80, 0xC0, 0x5C, 0x22, 0x72, 0x8C, 0x00, 0x00, 0x80, 0x0C, 0x10, 0x10, 0x10, 0x10, 0x08, 0x0C, 0x0C, 0x10, // 38
    0x0E, 0x00, // 39
    0xC0, 0x3C, 0x02, 0xFC, 0x00, 0x00, // 40
    0x00, 0xFE, 0x78, 0x04, // 41
    0x0C, 0x1E, 0x0C, 0x00, 0x00, 0x00, // 42
    0x20, 0x20, 0x20, 0xFC, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x00, 0x20, 0x10, 0x08, // 44
    0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, // 45
    0x00, 0x00, 0x18, 0x18, // 46
    0x00, 0x00, 0xE0, 0x1C, 0x02, 0x20, 0x1C, 0x00, 0x00, 0x00, // 47
    0xF0, 0x0C, 0x06, 0x02, 0x02, 0x86, 0xFC, 0x0C, 0x18, 0x10, 0x10, 0x08, 0x0C, 0x00, // 48
    0xC2, 0x3E, 0x1C, 0x00, // 49
    0x00, 0x0C, 0x06, 0x82, 0x42, 0x22, 0x1C, 0x10, 0x18, 0x14, 0x10, 0x10, 0x10, 0x00, // 50
    0x00, 0x04, 0x02, 0x22, 0x22, 0x72, 0xDC, 0x04, 0x18, 0x10, 0x10, 0x10, 0x08, 0x04, // 51
    0x00, 0x80, 0x40, 0x20, 0x10, 0xE8, 0x1E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1C, 0x04, // 52
    0x00, 0x00, 0x1C, 0x12, 0x32, 0xE2, 0x02, 0x0C, 0x18, 0x10, 0x10, 0x08, 0x04, 0x00, // 53
    0xC0, 0x30, 0x18, 0x14, 0x12, 0x20, 0xC0, 0x04, 0x08, 0x10, 0x10, 0x10, 0x08, 0x04, // 54
    0x00, 0x02, 0x82, 0x42, 0x32, 0x0A, 0x06, 0x02, 0x10, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 55
    0x80, 0x5C, 0x26, 0x22, 0x22, 0x52, 0xDC, 0x0C, 0x18, 0x10, 0x10, 0x10, 0x08, 0x04, // 56
    0x38, 0x44, 0x82, 0x82, 0x82, 0xC4, 0x38, 0x00, 0x00, 0x10, 0x08, 0x04, 0x00, 0x00, // 57
    0x00, 0x30, 0x30, 0x18, 0x18, 0x00, // 58
    0x00, 0x00, 0x30, 0x30, 0x30, 0x08, 0x00, 0x00, // 59
    0x20, 0x50, 0x50, 0x88, 0x88, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, // 60
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 61
    0x04, 0x88, 0x88, 0x50, 0x50, 0x20, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, // 62
    0x6C, 0xA6, 0x92, 0x92, 0x52, 0x0C, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, // 63
    0xF0, 0x0C, 0x04, 0xE2, 0x12, 0x12, 0xE2, 0x14, 0x8C, 0x78, 0x00, 0x0C, 0x08, 0x10, 0x14, 0x14, 0x14, 0x0C, 0x08, 0x00, // 64
    0x00, 0x80, 0xE0, 0x9C, 0x82, 0x9C, 0xE0, 0x00, 0x18, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x18, // 65
    0xC0, 0x3E, 0x22, 0x22, 0x22, 0x62, 0x9C, 0x1C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0C, // 66
    0xF0, 0x08, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x04, 0x08, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00, // 67
    0xC0, 0x3E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0xF8, 0x1C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00, // 68
    0xC0, 0x3E, 0x22, 0x22, 0x22, 0x22, 0x02, 0x1C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, // 69
    0xC0, 0x3E, 0x22, 0x22, 0x22, 0x02, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, // 70
    0xF0, 0x08, 0x04, 0x04, 0x02, 0x02, 0x42, 0x42, 0x42, 0x44, 0xC8, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00, // 71
    0xC0, 0x3E, 0x20, 0x20, 0x20, 0x20, 0x20, 0xE0, 0x3E, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, // 72
    0xC0, 0x3E, 0x1C, 0x00, // 73
    0x00, 0x00, 0x00, 0x00, 0xC0, 0x3E, 0x08, 0x10, 0x10, 0x10, 0x0C, 0x00, // 74
    0xC0, 0x3E, 0x60, 0x90, 0x08, 0x04, 0x02, 0x1C, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, // 75
    0xC0, 0x3E, 0x00, 0x00, 0x00, 0x1C, 0x10, 0x10, 0x10, 0x10, // 76
    0x00, 0xF8, 0x06, 0x38, 0xC0, 0x00, 0x00, 0xC0, 0x30, 0x0C, 0xFE, 0x1C, 0x00, 0x00, 0x00, 0x04, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x1C, // 77
    0xC0, 0x3E, 0x08, 0x10, 0x60, 0x80, 0x00, 0xC0, 0x3E, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x1C, 0x00, // 78
    0xE0, 0x18, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x84, 0x78, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x00, // 79
    0xC0, 0x3E, 0x22, 0x22, 0x22, 0x32, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 80
    0xF0, 0x18, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x04, 0x0C, 0xF8, 0x04, 0x0C, 0x08, 0x10, 0x10, 0x10, 0x10, 0x14, 0x08, 0x14, 0x10, // 81
    0xC0, 0x3E, 0x22, 0x62, 0xA2, 0x22, 0x32, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, // 82
    0x00, 0x1C, 0x22, 0x42, 0x86, 0x0C, 0x0C, 0x18, 0x10, 0x10, 0x0C, 0x00, // 83
    0x02, 0x02, 0xC2, 0x3E, 0x02, 0x02, 0x02, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, // 84
    0xC0, 0x3E, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3E, 0x0C, 0x18, 0x10, 0x10, 0x10, 0x18, 0x0C, 0x00, // 85
    0x0E, 0xF0, 0x00, 0x00, 0x80, 0x60, 0x10, 0x0C, 0x02, 0x00, 0x04, 0x18, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, // 86
    0x3E, 0xE0, 0x80, 0x60, 0x1C, 0x02, 0xFC, 0x80, 0x00, 0xC0, 0x30, 0x0C, 0x02, 0x00, 0x1C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x0C, 0x00, 0x00, 0x00, 0x00, // 87
    0x00, 0x00, 0x02, 0xCC, 0x30, 0xD0, 0x08, 0x04, 0x02, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x0C, 0x10, 0x00, // 88
    0x02, 0x0C, 0x90, 0x60, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, // 89
    0x00, 0x02, 0x82, 0x62, 0x1A, 0x06, 0x02, 0x10, 0x1C, 0x10, 0x10, 0x10, 0x10, 0x00, // 90
    0xC0, 0x3E, 0x02, 0xFC, 0x80, 0x00, // 91
    0x02, 0x0C, 0x30, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x18, 0x20, // 92
    0x00, 0xC2, 0x3E, 0x80, 0xFC, 0x00, // 93
    0x00, 0xE0, 0x1C, 0x02, 0x1C, 0xE0, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, // 95
    0x01, 0x02, 0x00, 0x00, // 96
    0xC0, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0xE0, 0x30, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x08, 0x1C, 0x00, // 97
    0xC0, 0x7E, 0x20, 0x10, 0x10, 0x10, 0x10, 0x20, 0xC0, 0x1C, 0x08, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, // 98
    0xC0, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x20, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, // 99
    0xC0, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0xE0, 0x3E, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x08, 0x1C, 0x00, // 100
    0xC0, 0xA0, 0x90, 0x90, 0x90, 0x90, 0xA0, 0xC0, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, // 101
    0xF0, 0x3E, 0x12, 0x12, 0x1C, 0x00, 0x00, 0x00, // 102
    0xC0, 0x20, 0x10, 0x10, 0x10, 0x10, 0xE0, 0x30, 0x44, 0x88, 0x90, 0x90, 0x90, 0x48, 0x3C, 0x00, // 103
    0xC0, 0x7E, 0x20, 0x10, 0x10, 0x10, 0xF0, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, // 104
    0xC0, 0x32, 0x1C, 0x00, // 105
    0xC0, 0x32, 0x7C, 0x00, // 106
    0xC0, 0xBE, 0xC0, 0x20, 0x20, 0x10, 0x1C, 0x00, 0x00, 0x04, 0x08, 0x10, // 107
    0xC0, 0x3E, 0x1C, 0x00, // 108
    0xC0, 0x70, 0x20, 0x10, 0x10, 0xF0, 0x20, 0x10, 0x10, 0x10, 0xF0, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x1C, // 109
    0xC0, 0x70, 0x20, 0x10, 0x10, 0x10, 0xE0, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, // 110
    0xC0, 0x20, 0x10, 0x10, 0x10, 0x10, 0x20, 0xC0, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x08, 0x04, // 111
    0xC0, 0x70, 0x20, 0x10, 0x10, 0x10, 0x10, 0x20, 0xC0, 0xFC, 0x08, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, // 112
    0xC0, 0x20, 0x30, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x30, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x08, 0xFC, 0x00, // 113
    0x80, 0x70, 0x10, 0x10, 0x1C, 0x00, 0x00, 0x00, // 114
    0x60, 0x90, 0x90, 0x20, 0x10, 0x10, 0x10, 0x0C, // 115
    0x10, 0xD0, 0x3E, 0x10, 0x10, 0x00, 0x1C, 0x00, 0x00, 0x00, // 116
    0xC0, 0x30, 0x00, 0x00, 0x00, 0xC0, 0x30, 0x04, 0x08, 0x10, 0x10, 0x10, 0x0C, 0x00, // 117
    0x30, 0xC0, 0x00, 0x00, 0x80, 0x60, 0x10, 0x00, 0x04, 0x18, 0x0C, 0x00, 0x00, 0x00, // 118
    0x30, 0xC0, 0x00, 0xE0, 0x10, 0xE0, 0x00, 0x00, 0x80, 0x60, 0x10, 0x00, 0x0C, 0x18, 0x04, 0x00, 0x00, 0x1C, 0x08, 0x04, 0x00, 0x00, // 119
    0x00, 0x10, 0x60, 0x80, 0x40, 0x20, 0x10, 0x10, 0x08, 0x04, 0x00, 0x0C, 0x10, 0x00, // 120
    0x30, 0xC0, 0x00, 0x00, 0xC0, 0x30, 0x80, 0x64, 0x18, 0x04, 0x00, 0x00, // 121
    0x00, 0x10, 0x90, 0x70, 0x10, 0x10, 0x1C, 0x10, 0x10, 0x10, // 122
    0x80, 0x40, 0x3C, 0x02, 0x02, 0x00, 0xFC, 0x80, 0x00, 0x00, // 123
    0xFE, 0xFC, // 124
    0x00, 0x02, 0x7E, 0x80, 0x80, 0x78, 0x04, 0x00, // 125
    0x40, 0x20, 0x20, 0x40, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFC, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFC, 0x1C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1C // 127
    
};

#endif
